﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Advent.aiDevices;

namespace Advent.Controls
{
    public partial class AMGenerator : UserControl
    {

        private AMModulator AMGen = null;

        public AMGenerator()
        {
            InitializeComponent();


            freq_Modulation.Freq = Frequency.InHz(100);
            freq_Carrier.Freq = Frequency.InkHz(3);

            cbo_ModulationShape.Items.Clear();
            cbo_ModulationShape.Items.Add(Waveshape.Sinusoiodal);
            cbo_ModulationShape.Items.Add(Waveshape.Triangular);
            cbo_ModulationShape.Items.Add(Waveshape.Square);
            cbo_ModulationShape.SelectedIndex = 0;
            cbo_ModulationShape.SelectedIndexChanged += new EventHandler(ControlSettingChanged);

            cbo_CarrierShape.Items.Clear();
            cbo_CarrierShape.Items.Add(Waveshape.Sinusoiodal);
            cbo_CarrierShape.Items.Add(Waveshape.Triangular);
            cbo_CarrierShape.Items.Add(Waveshape.Square);
            cbo_CarrierShape.SelectedIndex = 0;
            cbo_CarrierShape.SelectedIndexChanged += new EventHandler(ControlSettingChanged);

            level_Carrier.SignalLevelChanged += new EventHandler(ControlSettingChanged);
            freq_Carrier.FrequencyChanged += new EventHandler(ControlSettingChanged);
            freq_Modulation.FrequencyChanged += new EventHandler(ControlSettingChanged);

            txt_Depth.Validating += new CancelEventHandler(txt_Depth_Validating);
            txt_Depth.KeyUp += new KeyEventHandler(txt_Depth_KeyUp);


            this.EnabledChanged += new EventHandler(AMCtrl_EnabledChanged);

        }

        void AMCtrl_EnabledChanged(object sender, EventArgs e)
        {
            timer_Update.Enabled = this.Enabled;
        }

        void txt_Depth_KeyUp(object sender, KeyEventArgs e)
        {
            if (e.KeyCode != Keys.Return) return;
            ControlSettingChanged(sender, EventArgs.Empty);
        }

        void txt_Depth_Validating(object sender, CancelEventArgs e)
        {
            ControlSettingChanged(sender, EventArgs.Empty);
        }

        void ControlSettingChanged(object sender, EventArgs e)
        {
            try
            {
                if ((AMGen == null) || (!AMGen.IsActive)) return;

                AMGen.Update(Parse());
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        public void SetGenerator(AMModulator AMGen)
        {
            this.AMGen = AMGen;
        }

        private void btn_Stop_Click(object sender, EventArgs e)
        {
            try
            {
                AMGen.StopGenerator();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        /// <summary>
        /// returns an AM tone definition based on the current settings
        /// </summary>
        private AMTone Parse()
        {

            double Depth = 50;

            if (!double.TryParse(txt_Depth.Text, out Depth)) throw new Exception("Invalid Depth value");

            return  new AMTone(level_Carrier.Level,
                        freq_Carrier.Freq,
                        (Waveshape)cbo_CarrierShape.SelectedItem,
                        Depth,
                        freq_Modulation.Freq,
                        (Waveshape)cbo_ModulationShape.SelectedItem);
        }


        private void btn_Generate_Click(object sender, EventArgs e)
        {
            try
            {
                AMGen.Generate(Parse());
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void timer_Update_Tick(object sender, EventArgs e)
        {
            try
            {
                if (AMGen == null) return;
                if (AMGen.IsActive)
                {
                    gb_Generator.Text = "AM Generator (Active)";
                }
                else
                {
                    gb_Generator.Text = "AM Generator";
                }
            }
            catch { }
        }


    }
}
